//
//  GHRestingHeartRateData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 5/22/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHRestingHeartRateData class provides the resting heart rate data that was extracted from the Garmin device.
 */
@interface GHRestingHeartRateData : NSObject

/** Timestamp for the associated resting heart rate data. Can be null. */
@property (nullable, nonatomic, readonly) NSDate *timestamp;

/**
 * The rolling resting heart rate for the last seven days. Can be null.
 * @note Values are integers.
 */
@property (nullable, nonatomic, readonly) NSNumber *restingHeartRate;

/**
 * The  resting heart rate for the current day. Can be null.
 * @note Values are integers.
 */
@property (nonnull, nonatomic, readonly) NSNumber *currentDayRestingHeartRate;


@end
